document.addEventListener('DOMContentLoaded',()=>{
    const headerNav = document.querySelector('.header-nav'),
        burger = document.querySelector('.burger');

    if (headerNav && burger) {
        burger.addEventListener('click', (e) => {
            e.preventDefault();

            burger.classList.toggle('burger--active');
            headerNav.classList.toggle('header-nav--active');
        });
        headerNav.addEventListener('click', (e) => {
            if (e.target.classList.contains('header-nav')) {
                headerNav.classList.remove('header-nav--active')
                burger.classList.remove('burger--active');
            }
        })
    }


    const jsToggleWrapperArray = document.querySelectorAll('.js-toggle-wrapper');

    if (jsToggleWrapperArray.length) {
        jsToggleWrapperArray.forEach(jsToggleWrapper => {
            const jsToggleLink = jsToggleWrapper.querySelector('.js-toggle-link'),
                jsToggleBlock = jsToggleWrapper.querySelector('.js-toggle-block');

            jsToggleLink.addEventListener('click', (e) => {
                e.preventDefault();

                jsToggleBlock.classList.toggle('active');
                jsToggleLink.classList.toggle('js-toggle-link-active');
            })
        });
    }

    const jsColorArray = document.querySelectorAll('.js-add-color');

    if(jsColorArray.length){
        jsColorArray.forEach(jsColor=>{
            const jsColorInput = jsColor.querySelector('.js-add-color-input'),
                jsColorCheckmark = jsColor.querySelector('.js-add-color-checkmark');

            jsColorInput.addEventListener('input',()=>{
                const isHash = jsColorInput.value[0] === '#';
                jsColorCheckmark.style.backgroundColor = isHash ? `${jsColorInput.value}` : `#${jsColorInput.value}`;
            });
        })
    }

    const fileInputArray = document.querySelectorAll('.file-input');

    if(fileInputArray.length){
        fileInputArray.forEach(fileInput=>{
            const fileInputItem = fileInput.querySelector('.file-input__item'),
                fileInputLabel = fileInput.querySelector('.file-input__label');

            fileInputItem.addEventListener('change',(e)=>{
                fileInputLabel.textContent = fileInputItem.files[0].name;
            });
        });
    }

    const fileLabelArray = document.querySelectorAll('.file-label');

    if(fileLabelArray.length){
        fileLabelArray.forEach(fileLabel=>{

            const fileInput = fileLabel.querySelector('.file-label__input'),
                fileCheckmark = fileLabel.querySelector('.file-label__checkmark');

            fileInput.addEventListener('change',(e)=>{
                const file = e.target.files[0];
                const reader = new FileReader();

                reader.onloadend = function(){
                    fileCheckmark.style.backgroundImage = "url(" + reader.result + ")";
                    fileCheckmark.classList.add('file-label__checkmark--loaded');
                }
                if(file){
                    reader.readAsDataURL(file);
                }
            })
        });
    }

    const inputArray = document.querySelectorAll('.page-input__item');

    if(inputArray.length){
        inputArray.forEach(input=>{
            input.addEventListener('input',()=>{
                input.classList.remove('page-input__item--error');
                input.classList.remove('page-input__item--success');
                input.checkValidity() ? input.classList.add('page-input__item--success') : input.classList.add('page-input__item--error');
            })
        });
    }

    const socialBlockArray = document.querySelectorAll('.js-social');

    if(socialBlockArray.length){
        socialBlockArray.forEach(socialBlock=>{
            const socialInputArray = socialBlock.querySelectorAll('input[type="radio"]'),
                socialImg = socialBlock.querySelector('.js-social-img'),
                socialWrapper = socialBlock.querySelector('.social');


            socialInputArray.forEach(socialInput=>{
                socialInput.addEventListener('change',(e)=>{
                    socialWrapper.classList.add('social--active');
                    const radioImg = socialInput.closest('.radio').querySelector('.radio__img');
                    socialImg.style.backgroundImage = radioImg.style.backgroundImage;
                });
            });
        });
    }
})