const checkTargetOrKey = event => {
    if (
        event.target.classList.contains('popup__wrapper') ||
        event.key === 'Escape' ||
        event.target.closest('.popup-close')
    ) {
        hideAllPopups();
    }
};
const showPopup = popupId => {
    const popup = document.querySelector(popupId);
    if (!popup) return

    const pageWrapper = document.querySelector('.page-wrapper');

    hideAllPopups();

    popup.classList.add('popup--active');
    pageWrapper.classList.add('no-scroll');

    document.addEventListener('click', checkTargetOrKey);
    document.addEventListener('keyup', checkTargetOrKey);
};
const hideAllPopups = () => {
    const popups = document.querySelectorAll('.popup'),
        pageWrapper = document.querySelector('.page-wrapper');

    popups.forEach(popup => {
        popup.classList.remove('popup--active');
    });
    pageWrapper.classList.remove('no-scroll');

    document.removeEventListener('click', checkTargetOrKey);
    document.removeEventListener('keyup', checkTargetOrKey);
};

document.addEventListener('DOMContentLoaded', () => {
    const __sliderPaginationParams = {
        el: '.slider-pagination',
        hiddenClass: 'slider-pagination--hidden',
        bulletClass: 'slider-pagination__bullet',
        bulletActiveClass: 'slider-pagination__bullet--active',
    }
    const __sliderNavigationParams = {
        nextEl: '.slider__button--next',
        prevEl: '.slider__button--prev',
        hiddenClass: 'slider__button--hidden',
        disabledClass: 'slider__button--disabled',
    }
    const sliderAuto = new Swiper('.slider-auto', {
        slidesPerView: 'auto',
        spaceBetween: 10,
        // If we need pagination
        pagination: __sliderPaginationParams,
        navigation: __sliderNavigationParams,
        breakpoints: {
            640: {
                slidesPerView:4,
                spaceBetween: 20,
                grid:{
                    rows:2,
                    fill:'row',
                },
            },
            800:{
              slidesPerView:7,
                spaceBetween:10,
                grid:{
                    rows:2,
                    fill:'row',
                },
            },
            1280:{
                slidesPerView:10,
                spaceBetween:20,
                grid:{
                    rows:2,
                    fill:'row',
                },
            },
        }
    });


    // gallery slider
    const galleryArray = document.querySelectorAll('.gallery');
    if (galleryArray.length) {
        const galleryPopup = document.createElement('div'),
            galleryWrapper = document.createElement('div'),
            galleryContainer = document.createElement('div'),
            galleryContent = document.createElement('div'),
            galleryButtonNext = document.createElement('div'),
            galleryButtonPrev = document.createElement('div'),
            galleryClose = document.createElement('div');

        galleryPopup.classList.add('popup', 'popup-gallery');
        galleryWrapper.classList.add('popup__wrapper');
        galleryContainer.classList.add('popup__container');
        galleryContent.classList.add('popup__content');

        galleryButtonNext.classList.add('popup__button', 'popup__button--next');
        galleryButtonPrev.classList.add('popup__button', 'popup__button--prev');
        galleryClose.classList.add('popup__close', 'popup-close');


        galleryContainer.append(galleryButtonPrev);
        galleryContainer.append(galleryContent);
        galleryContainer.append(galleryButtonNext);
        galleryContainer.append(galleryClose);

        galleryPopup.append(galleryWrapper);
        galleryContainer.append(galleryContent);
        galleryWrapper.append(galleryContainer);
        galleryPopup.append(galleryWrapper);

        document.body.append(galleryPopup);

        const createGalleryBlock = (tag = 'img', source) => {
            const galleryBlock = document.createElement(tag);
            galleryBlock.setAttribute('src', source);
            galleryBlock.setAttribute('autoplay', '');
            galleryBlock.setAttribute('controls', '');


            return galleryBlock;
        }

        const changeGallerySlide = (value) => {
            const galleryName = galleryPopup.dataset.name,
                galleryItemIndex = galleryPopup.dataset.index;

            const galleryBlock = document.querySelector(`[data-gallery=${galleryName}]`);
            if (!galleryBlock) return false;

            const galleryBlockItems = galleryBlock.querySelectorAll('.gallery-item');
            if (!galleryBlockItems.length) return false;

            const newValue = +galleryItemIndex + value;

            if (newValue < 0 || newValue > galleryBlockItems.length) return false;

            galleryContent.innerHTML = '';
            galleryContent.append(createGalleryBlock(galleryBlockItems[newValue].dataset.tag, galleryBlockItems[newValue].getAttribute('href')))

            galleryPopup.dataset.index = newValue;
        }

        galleryButtonNext.addEventListener('click', (e) => {
            e.preventDefault();
            changeGallerySlide(1)
        });
        galleryButtonPrev.addEventListener('click', (e) => {
            e.preventDefault();
            changeGallerySlide(-1)
        });

        galleryArray.forEach(gallery => {
            const galleryItemArray = gallery.querySelectorAll('.gallery-item');
            if (galleryArray.length) {
                galleryItemArray.forEach((galleryItem, galleryIndex) => {
                    galleryItem.addEventListener('click', (e) => {
                        e.preventDefault();

                        galleryContent.innerHTML = '';
                        galleryContent.append(createGalleryBlock(galleryItem.dataset.tag, galleryItem.getAttribute('href')));
                        galleryPopup.dataset.index = `${galleryIndex}`;
                        galleryPopup.dataset.name = `${gallery.dataset.gallery}`;
                        showPopup('.popup-gallery');
                    })
                });
            }
        });
    }


    const headerNav = document.querySelector('.header-nav'),
        burger = document.querySelector('.burger');

    if (headerNav && burger) {
        burger.addEventListener('click', (e) => {
            e.preventDefault();

            burger.classList.toggle('burger--active');
            headerNav.classList.toggle('header-nav--active');
        });
        headerNav.addEventListener('click', (e) => {
            if (e.target.classList.contains('header-nav')) {
                headerNav.classList.remove('header-nav--active')
                burger.classList.remove('burger--active');
            }
        })
    }


    const jsToggleWrapperArray = document.querySelectorAll('.js-toggle-wrapper');

    if (jsToggleWrapperArray.length) {
        jsToggleWrapperArray.forEach(jsToggleWrapper => {
            const jsToggleLink = jsToggleWrapper.querySelector('.js-toggle-link'),
                jsToggleBlock = jsToggleWrapper.querySelector('.js-toggle-block');

            jsToggleLink.addEventListener('click', (e) => {
                e.preventDefault();

                jsToggleBlock.classList.toggle('active');
                jsToggleLink.classList.toggle('js-toggle-link-active');
            })
        });
    }

    const cardVideo = document.querySelectorAll('.card-video');

    const videoPage = document.querySelector('.video-page');

    if(videoPage){
        const videoPageItem = document.querySelector('.card-video'),
            video = videoPageItem.querySelector('video');

        window.addEventListener('scroll',()=>{
            video.pause();
            videoPageItem.classList.remove('card-video--active');
        });
    }

    if(cardVideo.length){
        cardVideo.forEach(element=>{
           const video = element.querySelector('video');

            element.addEventListener("click",(e)=>{
              e.preventDefault();

                element.classList.toggle('card-video--active');
              if(element.classList.contains('card-video--active')){
                  video.play();
              }else{
                  video.pause();
              }
           });
        });
    }
});